/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.gui.scenes.login;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import pro.gravit.launcher.base.events.request.AuthRequestEvent;
import pro.gravit.launcher.base.events.request.GetAvailabilityAuthRequestEvent;
import pro.gravit.launcher.base.request.Request;
import pro.gravit.launcher.base.request.RequestException;
import pro.gravit.launcher.base.request.auth.AuthRequest;
import pro.gravit.launcher.base.request.auth.RefreshTokenRequest;
import pro.gravit.launcher.base.request.auth.details.AuthLoginOnlyDetails;
import pro.gravit.launcher.base.request.auth.details.AuthPasswordDetails;
import pro.gravit.launcher.base.request.auth.details.AuthTotpDetails;
import pro.gravit.launcher.base.request.auth.details.AuthWebViewDetails;
import pro.gravit.launcher.base.request.auth.password.Auth2FAPassword;
import pro.gravit.launcher.base.request.auth.password.AuthMultiPassword;
import pro.gravit.launcher.base.request.auth.password.AuthOAuthPassword;
import pro.gravit.launcher.gui.JavaFXApplication;
import pro.gravit.launcher.gui.scenes.login.LoginAuthButtonComponent;
import pro.gravit.launcher.gui.scenes.login.LoginScene;
import pro.gravit.launcher.gui.scenes.login.methods.AbstractAuthMethod;
import pro.gravit.launcher.gui.scenes.login.methods.LoginAndPasswordAuthMethod;
import pro.gravit.launcher.gui.scenes.login.methods.LoginOnlyAuthMethod;
import pro.gravit.launcher.gui.scenes.login.methods.TotpAuthMethod;
import pro.gravit.launcher.gui.scenes.login.methods.WebAuthMethod;
import pro.gravit.utils.helper.LogHelper;

public class AuthFlow {
    public Map<Class<? extends GetAvailabilityAuthRequestEvent.AuthAvailabilityDetails>, AbstractAuthMethod<? extends GetAvailabilityAuthRequestEvent.AuthAvailabilityDetails>> authMethods = new HashMap<Class<? extends GetAvailabilityAuthRequestEvent.AuthAvailabilityDetails>, AbstractAuthMethod<? extends GetAvailabilityAuthRequestEvent.AuthAvailabilityDetails>>(8);
    private final LoginScene.LoginSceneAccessor accessor;
    private final List<Integer> authFlow = new ArrayList<Integer>();
    private GetAvailabilityAuthRequestEvent.AuthAvailability authAvailability;
    private volatile AbstractAuthMethod<GetAvailabilityAuthRequestEvent.AuthAvailabilityDetails> authMethodOnShow;
    private final Consumer<SuccessAuth> onSuccessAuth;
    public boolean isLoginStarted;

    public AuthFlow(LoginScene.LoginSceneAccessor accessor, Consumer<SuccessAuth> onSuccessAuth) {
        this.accessor = accessor;
        this.onSuccessAuth = onSuccessAuth;
        this.authMethods.put(AuthPasswordDetails.class, new LoginAndPasswordAuthMethod(accessor));
        this.authMethods.put(AuthWebViewDetails.class, new WebAuthMethod(accessor));
        this.authMethods.put(AuthTotpDetails.class, new TotpAuthMethod(accessor));
        this.authMethods.put(AuthLoginOnlyDetails.class, new LoginOnlyAuthMethod(accessor));
    }

    public void init(GetAvailabilityAuthRequestEvent.AuthAvailability authAvailability) {
        this.authAvailability = authAvailability;
        this.reset();
    }

    public void reset() {
        this.authFlow.clear();
        this.authFlow.add(0);
        if (this.authMethodOnShow != null) {
            this.authMethodOnShow.onUserCancel();
        }
        if (!this.accessor.isEmptyContent()) {
            this.accessor.clearContent();
            this.accessor.setState(LoginAuthButtonComponent.AuthButtonState.ACTIVE);
        }
        if (this.authMethodOnShow != null && !this.authMethodOnShow.isOverlay()) {
            this.loginWithGui();
        }
        this.authMethodOnShow = null;
        for (AbstractAuthMethod<? extends GetAvailabilityAuthRequestEvent.AuthAvailabilityDetails> e : this.authMethods.values()) {
            e.reset();
        }
    }

    private CompletableFuture<LoginAndPasswordResult> tryLogin(String resentLogin, AuthRequest.AuthPasswordInterface resentPassword) {
        CompletionStage<LoginAndPasswordResult> authFuture = null;
        if (resentPassword != null) {
            authFuture = new CompletableFuture<LoginAndPasswordResult>();
            ((CompletableFuture)authFuture).complete(new LoginAndPasswordResult(resentLogin, resentPassword));
        }
        for (int i : this.authFlow) {
            GetAvailabilityAuthRequestEvent.AuthAvailabilityDetails details = (GetAvailabilityAuthRequestEvent.AuthAvailabilityDetails)this.authAvailability.details.get(i);
            AbstractAuthMethod<GetAvailabilityAuthRequestEvent.AuthAvailabilityDetails> authMethod = this.detailsToMethod(details);
            if (authFuture == null) {
                authFuture = ((CompletableFuture)((CompletableFuture)authMethod.show(details).thenCompose(x -> {
                    this.authMethodOnShow = authMethod;
                    return CompletableFuture.completedFuture(x);
                })).thenCompose(e -> authMethod.auth(details))).thenCompose(x -> {
                    this.authMethodOnShow = null;
                    return CompletableFuture.completedFuture(x);
                });
            } else {
                authFuture = ((CompletableFuture)authFuture).thenCompose(e -> authMethod.show(details).thenApply(x -> e));
                authFuture = ((CompletableFuture)authFuture).thenCompose(x -> {
                    this.authMethodOnShow = authMethod;
                    return CompletableFuture.completedFuture(x);
                });
                authFuture = ((CompletableFuture)authFuture).thenCompose(first -> authMethod.auth(details).thenApply(second -> {
                    AuthRequest.AuthPasswordInterface password;
                    AuthRequest.AuthPasswordInterface patt0$temp;
                    String login = null;
                    if (first.login != null) {
                        login = first.login;
                    }
                    if (second.login != null) {
                        login = second.login;
                    }
                    if ((patt0$temp = first.password) instanceof AuthMultiPassword) {
                        AuthMultiPassword authMultiPassword = (AuthMultiPassword)patt0$temp;
                        password = first.password;
                        authMultiPassword.list.add(second.password);
                    } else {
                        AuthRequest.AuthPasswordInterface patt1$temp = first.password;
                        if (patt1$temp instanceof Auth2FAPassword) {
                            Auth2FAPassword auth2FAPassword = (Auth2FAPassword)patt1$temp;
                            password = new AuthMultiPassword();
                            ((AuthMultiPassword)password).list = new ArrayList();
                            ((AuthMultiPassword)password).list.add(auth2FAPassword.firstPassword);
                            ((AuthMultiPassword)password).list.add(auth2FAPassword.secondPassword);
                            ((AuthMultiPassword)password).list.add(second.password);
                        } else {
                            password = new Auth2FAPassword();
                            ((Auth2FAPassword)password).firstPassword = first.password;
                            ((Auth2FAPassword)password).secondPassword = second.password;
                        }
                    }
                    return new LoginAndPasswordResult(login, password);
                }));
                authFuture = ((CompletableFuture)authFuture).thenCompose(x -> {
                    this.authMethodOnShow = null;
                    return CompletableFuture.completedFuture(x);
                });
            }
            authFuture = ((CompletableFuture)authFuture).thenCompose(e -> authMethod.hide().thenApply(x -> e));
        }
        return authFuture;
    }

    public AbstractAuthMethod<GetAvailabilityAuthRequestEvent.AuthAvailabilityDetails> getAuthMethodOnShow() {
        return this.authMethodOnShow;
    }

    private void start(CompletableFuture<SuccessAuth> result, String resentLogin, AuthRequest.AuthPasswordInterface resentPassword) {
        CompletableFuture<LoginAndPasswordResult> authFuture = this.tryLogin(resentLogin, resentPassword);
        ((CompletableFuture)authFuture.thenAccept(e -> this.login(e.login, e.password, this.authAvailability, result))).exceptionally(e -> {
            e = e.getCause();
            this.reset();
            this.isLoginStarted = false;
            if (e instanceof AbstractAuthMethod.UserAuthCanceledException) {
                return null;
            }
            this.accessor.errorHandle((Throwable)e);
            return null;
        });
    }

    private CompletableFuture<SuccessAuth> start() {
        CompletableFuture<SuccessAuth> result = new CompletableFuture<SuccessAuth>();
        this.start(result, null, null);
        return result;
    }

    private void login(String login, AuthRequest.AuthPasswordInterface password, GetAvailabilityAuthRequestEvent.AuthAvailability authId, CompletableFuture<SuccessAuth> result) {
        this.isLoginStarted = true;
        JavaFXApplication application = this.accessor.getApplication();
        LogHelper.dev((String)"Auth with %s password ***** authId %s", (Object[])new Object[]{login, authId});
        AuthRequest authRequest = application.authService.makeAuthRequest(login, password, authId.name);
        this.accessor.processing(authRequest, application.getTranslation("runtime.overlay.processing.text.auth"), event -> result.complete(new SuccessAuth((AuthRequestEvent)event, login, password)), error -> {
            if (error.equals("auth.invalidtoken")) {
                application.runtimeSettings.oauthAccessToken = null;
                application.runtimeSettings.oauthRefreshToken = null;
                result.completeExceptionally((Throwable)new RequestException(error));
            } else if (error.equals("auth.require2fa")) {
                this.authFlow.clear();
                this.authFlow.add(1);
                this.accessor.runInFxThread(() -> this.start(result, login, password));
            } else if (error.startsWith("auth.require.factor.")) {
                ArrayList<Integer> newAuthFlow = new ArrayList<Integer>();
                for (String s : error.substring("auth.require.factor.".length() + 1).split("\\.")) {
                    newAuthFlow.add(Integer.parseInt(s));
                }
                this.authFlow.clear();
                this.authFlow.addAll(newAuthFlow);
                this.accessor.runInFxThread(() -> this.start(result, login, password));
            } else {
                this.authFlow.clear();
                this.authFlow.add(0);
                this.accessor.errorHandle((Throwable)new RequestException(error));
            }
        });
    }

    void loginWithGui() {
        this.accessor.setState(LoginAuthButtonComponent.AuthButtonState.UNACTIVE);
        AbstractAuthMethod<GetAvailabilityAuthRequestEvent.AuthAvailabilityDetails> method = this.getAuthMethodOnShow();
        if (method != null) {
            method.onAuthClicked();
            return;
        }
        if (this.tryOAuthLogin()) {
            return;
        }
        this.start().thenAccept(result -> {
            if (this.onSuccessAuth != null) {
                this.onSuccessAuth.accept((SuccessAuth)result);
            }
        });
    }

    private boolean tryOAuthLogin() {
        JavaFXApplication application = this.accessor.getApplication();
        if (application.runtimeSettings.lastAuth != null && this.authAvailability.name.equals(application.runtimeSettings.lastAuth.name) && application.runtimeSettings.oauthAccessToken != null) {
            if (application.runtimeSettings.oauthExpire != 0L && application.runtimeSettings.oauthExpire < System.currentTimeMillis()) {
                this.refreshToken();
                return true;
            }
            Request.setOAuth((String)this.authAvailability.name, (AuthRequestEvent.OAuthRequestEvent)new AuthRequestEvent.OAuthRequestEvent(application.runtimeSettings.oauthAccessToken, application.runtimeSettings.oauthRefreshToken, application.runtimeSettings.oauthExpire), (long)application.runtimeSettings.oauthExpire);
            AuthOAuthPassword password = new AuthOAuthPassword(application.runtimeSettings.oauthAccessToken);
            LogHelper.info((String)"Login with OAuth AccessToken");
            this.loginWithOAuth(password, this.authAvailability, true);
            return true;
        }
        return false;
    }

    private void refreshToken() {
        JavaFXApplication application = this.accessor.getApplication();
        RefreshTokenRequest request = new RefreshTokenRequest(this.authAvailability.name, application.runtimeSettings.oauthRefreshToken);
        this.accessor.processing(request, application.getTranslation("runtime.overlay.processing.text.auth"), result -> {
            application.runtimeSettings.oauthAccessToken = result.oauth.accessToken;
            application.runtimeSettings.oauthRefreshToken = result.oauth.refreshToken;
            application.runtimeSettings.oauthExpire = result.oauth.expire == 0L ? 0L : System.currentTimeMillis() + result.oauth.expire;
            Request.setOAuth((String)this.authAvailability.name, (AuthRequestEvent.OAuthRequestEvent)result.oauth);
            AuthOAuthPassword password = new AuthOAuthPassword(application.runtimeSettings.oauthAccessToken);
            LogHelper.info((String)"Login with OAuth AccessToken");
            this.loginWithOAuth(password, this.authAvailability, false);
        }, error -> {
            application.runtimeSettings.oauthAccessToken = null;
            application.runtimeSettings.oauthRefreshToken = null;
            this.accessor.runInFxThread(this::loginWithGui);
        });
    }

    private void loginWithOAuth(AuthOAuthPassword password, GetAvailabilityAuthRequestEvent.AuthAvailability authAvailability, boolean refreshIfError) {
        JavaFXApplication application = this.accessor.getApplication();
        AuthRequest authRequest = application.authService.makeAuthRequest(null, (AuthRequest.AuthPasswordInterface)password, authAvailability.name);
        this.accessor.processing(authRequest, application.getTranslation("runtime.overlay.processing.text.auth"), result -> this.accessor.runInFxThread(() -> this.onSuccessAuth.accept(new SuccessAuth((AuthRequestEvent)result, null, null))), error -> {
            if (refreshIfError && error.equals("auth.expiretoken")) {
                this.refreshToken();
                return;
            }
            if (error.equals("auth.invalidtoken")) {
                application.runtimeSettings.oauthAccessToken = null;
                application.runtimeSettings.oauthRefreshToken = null;
                this.accessor.runInFxThread(this::loginWithGui);
            } else {
                this.accessor.errorHandle((Throwable)new RequestException(error));
            }
        });
    }

    private AbstractAuthMethod<GetAvailabilityAuthRequestEvent.AuthAvailabilityDetails> detailsToMethod(GetAvailabilityAuthRequestEvent.AuthAvailabilityDetails details) {
        return this.authMethods.get(details.getClass());
    }

    public void prepare() {
        this.authMethods.forEach((k, v) -> v.prepare());
    }

    public record LoginAndPasswordResult(String login, AuthRequest.AuthPasswordInterface password) {
    }

    public record SuccessAuth(AuthRequestEvent requestEvent, String recentLogin, AuthRequest.AuthPasswordInterface recentPassword) {
    }
}

